/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.base.data.recipe;

import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.base.data.recipe.DyedRecipeList;
import dev.ithundxr.createnumismatics.base.data.recipe.NumismaticsRecipeProvider;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;

public class NumismaticsStandardRecipeGen
extends NumismaticsRecipeProvider {
    NumismaticsRecipeProvider.GeneratedRecipe ANDESITE_DEPOSITOR = this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsBlocks.ANDESITE_DEPOSITOR).unlockedBy(NumismaticsRecipeProvider.Ingredients::andesiteCasing).viaShapeless(b -> b.m_126209_(NumismaticsRecipeProvider.Ingredients.andesiteCasing()).m_206419_(NumismaticsRecipeProvider.Ingredients.ironSheet()));
    NumismaticsRecipeProvider.GeneratedRecipe BRASS_DEPOSITOR = this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsBlocks.BRASS_DEPOSITOR).unlockedBy(NumismaticsRecipeProvider.Ingredients::brassCasing).viaShapeless(b -> b.m_126209_(NumismaticsRecipeProvider.Ingredients.brassCasing()).m_126209_(NumismaticsRecipeProvider.Ingredients.sturdySheet()).m_126209_(NumismaticsRecipeProvider.Ingredients.electronTube()));
    NumismaticsRecipeProvider.GeneratedRecipe BANK_TERMINAL = this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsBlocks.BANK_TERMINAL).unlockedBy(NumismaticsRecipeProvider.Ingredients::precisionMechanism).viaShapeless(b -> b.m_126209_(NumismaticsRecipeProvider.Ingredients.precisionMechanism()).m_126209_(NumismaticsRecipeProvider.Ingredients.industrialIron()).m_126209_(NumismaticsRecipeProvider.Ingredients.electronTube()));
    NumismaticsRecipeProvider.GeneratedRecipe BANKING_GUIDE = this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsItems.BANKING_GUIDE).unlockedBy(NumismaticsRecipeProvider.Ingredients::cogCoin).viaShapeless(b -> b.m_126209_(NumismaticsRecipeProvider.Ingredients.cogCoin()).m_126209_(NumismaticsRecipeProvider.Ingredients.sturdySheet()).m_126209_(NumismaticsRecipeProvider.Ingredients.paper()));
    NumismaticsRecipeProvider.GeneratedRecipe VENDOR = this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsBlocks.VENDOR).unlockedBy(NumismaticsRecipeProvider.Ingredients::brassCasing).viaShaped(b -> b.m_126130_("o").m_126130_("#").m_126130_("I").m_126127_(Character.valueOf('o'), NumismaticsRecipeProvider.Ingredients.framedGlass()).m_126127_(Character.valueOf('#'), NumismaticsRecipeProvider.Ingredients.brassCasing()).m_126127_(Character.valueOf('I'), NumismaticsRecipeProvider.Ingredients.electronTube()));
    DyedRecipeList CARDS = new DyedRecipeList(color -> this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsItems.CARDS.get((DyeColor)color)).unlockedBy(NumismaticsRecipeProvider.Ingredients::precisionMechanism).viaShaped(b -> b.m_126130_("@_/").m_126127_(Character.valueOf('@'), NumismaticsRecipeProvider.Ingredients.precisionMechanism()).m_206416_(Character.valueOf('_'), NumismaticsRecipeProvider.Ingredients.ironSheet()).m_206416_(Character.valueOf('/'), NumismaticsRecipeProvider.Ingredients.dye(color))));
    DyedRecipeList ID_CARDS = new DyedRecipeList(color -> this.create((ItemProviderEntry<? extends ItemLike>)NumismaticsItems.ID_CARDS.get((DyeColor)color)).unlockedBy(NumismaticsRecipeProvider.Ingredients::precisionMechanism).viaShaped(b -> b.m_126130_(" / ").m_126130_("_-,").m_206416_(Character.valueOf(','), NumismaticsRecipeProvider.Ingredients.brassNugget()).m_126127_(Character.valueOf('-'), NumismaticsRecipeProvider.Ingredients.paper()).m_206416_(Character.valueOf('_'), NumismaticsRecipeProvider.Ingredients.ironSheet()).m_206416_(Character.valueOf('/'), NumismaticsRecipeProvider.Ingredients.dye(color))));

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create(() -> result.get());
    }

    public NumismaticsStandardRecipeGen(PackOutput pOutput) {
        super(pOutput);
    }

    public String m_6055_() {
        return "Numismatics Standard Recipes";
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        NumismaticsRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return NumismaticsStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        NumismaticsRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return NumismaticsStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return Numismatics.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return Numismatics.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjects.getKeyOrThrow((Item)this.result.get().m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get())));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final SimpleCookingSerializer<?> FURNACE = (SimpleCookingSerializer)RecipeSerializer.f_44091_;
            private final SimpleCookingSerializer<?> SMOKER = (SimpleCookingSerializer)RecipeSerializer.f_44093_;
            private final SimpleCookingSerializer<?> BLAST = (SimpleCookingSerializer)RecipeSerializer.f_44092_;
            private final SimpleCookingSerializer<?> CAMPFIRE = (SimpleCookingSerializer)RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            NumismaticsRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            NumismaticsRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            NumismaticsRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            NumismaticsRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            NumismaticsRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            NumismaticsRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private NumismaticsRecipeProvider.GeneratedRecipe create(SimpleCookingSerializer<?> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return NumismaticsStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247607_((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(result -> consumer.accept(result), GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjects.getKeyOrThrow((RecipeSerializer)serializer).m_135815_()));
                });
            }
        }
    }
}

